function contours = mesh_slicer(mesh,slice)
%MESH_SLICER   Returnes a countor obtained by slicing a mesh with a plane.
% MESH_SLICER(MESH,SLICE)
% MESH, a triangle mesh struct containg fields vertices and faces.
% SLICE, a vector [a b c d] defining a plane ax+by+cz+d=0. Slice can also
%   be a matrix of slices.
% Author: vand@dtu.dk

verts = mesh.vertices;
faces = mesh.faces;

for s = 1:size(slice,1)
    
    v_dist = verts*slice(s,1:3)' + slice(s,4); % distance of each vertex to slice
    fcomb = sign(v_dist(faces)); % 10 combinations for a face, fx [above on under] etc
    
    % we remove faces where all or two of vertices are on the same side
    intersecting_faces = abs(sum(fcomb,2))<2 & sum(abs(fcomb),2)>0;
    % opposite vertices and face for each edge
    [C,D] = faces_to_circulator(faces);
    
    component = 1; % in case of more than one contour component
    contours{s}{1} = []; % in case of empty cut
    
    % BOOKKEEPING:
    % last_visited - length 1 or 2 vector containing indices of the last
    %           visited face or face pair
    % first and current -  length 1 or 2 vector containing indices of the
    %           vertex or edge where last contour point was found
    while any(intersecting_faces)
        % FIRST TWO CONTOUR POINTS FOUND ON FIRST NOT VISITED FACE
        k = find(intersecting_faces,1,'first');
        comb = sign(v_dist(faces(k,:)));
        if sum(abs(comb))==1 % first face is [on on above/under]
            on_slice = find(comb==0);
            first = faces(k,on_slice(1));
            current = faces(k,on_slice(2));
            last_visited = [D(first,current),D(current,first)];  % one of those is k
            contour(1:2,:) = verts([first;current],:);
        elseif sum(comb)==0 % first face is [on above under]
            on_slice = find(comb==0);
            first = faces(k,on_slice); % one element
            current = faces(k,mod(on_slice+[0 1],3)+1); % two elements for an edge
            last_visited = k;
            contour(1,:) = verts(first,:);
            contour(2,:) = edge_slice_intersection...
                (verts(current(:),:),v_dist(current));
        else % first face is [above above/under under]
            other = find(comb~=sign(sum(comb)));
            same = mod(other+[0 1],3)+1;
            first = faces(k,[other same(1)]);
            current = faces(k,[same(2) other]);
            last_visited = k;
            contour(1,:) = edge_slice_intersection...
                (verts(first(:),:),v_dist(first));
            contour(2,:) = edge_slice_intersection...
                (verts(current(:),:),v_dist(current));
        end
        intersecting_faces(last_visited) = false;
        
        % ITERETIVELY FINDING OTHER POINTS UNTIL GETTING BACK
        while length(first)~=length(current) || any(first(end:-1:1)~=current)
            if length(current)==2 % current is edge point
                opp_next = C(current(2),current(1));
                last_visited = D(current(2),current(1));
                if v_dist(opp_next)==0 % next is vertex point
                    current = opp_next;
                    contour(size(contour,1)+1,:) = verts(current,:);
                else
                    % find out which edge to consider and calculate intersection
                    if sign(v_dist(current(1)))==sign(v_dist(opp_next))
                        current = [opp_next current(2)];
                    else
                        current = [current(1) opp_next];
                    end
                    contour(size(contour,1)+1,:) = edge_slice_intersection...
                        (verts(current(:),:),v_dist(current));
                end
            else % length(current=1), vertex point
                % find all other faces around vertex
                [~,~,star] = find(D(current,:));
                % we now consider not visited intersection faces
                last_visited = star(intersecting_faces(star)==true);   % PROBLEM: THIS MAY RESULT IN MORE THAN 2 FACES!!!
                
                %%%%%%%%%%  trying to fix the problem
                if length(last_visited)>2
                    guess = find(sum(fcomb(last_visited,:),2)==0,1,'first');
                    if ~isempty(guess) % it was a lucky guess
                        last_visited = last_visited(guess); % reducing to just one face
                    else
                        candidates = sort(reshape(faces(last_visited,:),[],1));
                        candidates(candidates==current)=[];
                        next_vertex = candidates(find(diff(candidates)==0,1,'first'));
                        last_visited = last_visited(any(faces(last_visited,:)==next_vertex,2)); % reducing to two faces
                    end
                end
                %%%%%%%%%% end of fix
                
                if length(last_visited)==1 % one [on above under] face
                    on_slice = find(faces(last_visited,:)==current);
                    current = faces(last_visited,mod(on_slice+[0 1],3)+1);
                    contour(size(contour,1)+1,:) = edge_slice_intersection...
                        (verts(current(:),:),v_dist(current));
                else % two [on on above/under] faces
                    current = setdiff(intersect(faces(last_visited(1),:),...
                        faces(last_visited(2),:)),current);             % PROBLEM: THIS MAY ASSIGN AN EMPTY MATRIX
                    contour(size(contour,1)+1,:) = verts(current,:);
                end
            end
            intersecting_faces(last_visited) = false;
        end
        contours{s}{component} = contour(1:end-1,:);
        component = component + 1;
        clear contour
    end
    
end

end


function x = edge_slice_intersection(v,d)

x = v(1,:) + abs(d(1))/sum(abs(d))*(v(2,:)-v(1,:));

end

function [C,D] = faces_to_circulator(faces)
% C is a kind of adjacency matrix, pointing to the next vertex around the
% face. If there is an edge (a,b) then is C(a,b)_c a third vertex of the
% face (a,b,c). Matrix D contains index of the face (a,b,c) in the element
% D(a,b).

e = [faces; faces(:,[3 1 2]); faces(:,[2 3 1])];
C = sparse(e(:,1),e(:,2),e(:,3));
if nargout>1
    F = size(faces,1);
    D = sparse(e(:,1),e(:,2),repmat(1:F,[1 3]));
end
end


