function inspect_volume_and_contours(V,mesh,direction)
%INSPECT_VOLUME_AND_CONTOURS(V,MESH,DIRECTION) Interactive inspection
%   Interactive inspection of the volumetric data and the associated mesh
%       Inputs:
%           volume V 
%           mesh (can also be a cell of meshes), 
%           direction, slicin direction, defaults to z
%   Author: vand@dtu.dk

clim = [min(V(:)),max(V(:))];
if ~iscell(mesh) % to support more than one layer
    mesh = {mesh};
end
K = length(mesh); % number of layers
col = jet(K);
% rotating if direction different then default z
if nargin>2 && direction == 'x'
    Vdir = permute(V,[2 3 1]);
    vertsdir = cellfun(@(m) m.vertices(:,[2 3 1]),mesh,...
        'UniformOutput',false);
    xlab = 'y'; ylab = 'z';
elseif nargin>2 && direction =='y'
    Vdir = permute(V,[1 3 2]);
    vertsdir = cellfun(@(m) m.vertices(:,[1 3 2]),mesh,...
        'UniformOutput',false);
    xlab = 'x'; ylab = 'z';
else % 'z'
    direction = 'z';
    Vdir = V;
    vertsdir = cellfun(@(m) m.vertices,mesh,'UniformOutput',false);
    xlab = 'x'; ylab = 'y';
end

Z = size(Vdir,3);
fig = figure('Units','Normalized','Position',[0.1 0.3 0.5 0.6],...
    'KeyPressFcn',@key_press);
%z = round(0.5*(Z+1));
z = round(mean(vertsdir{1}(:,3)));
imagesc(Vdir(:,:,z)',clim) % transpose since I insist on having xyz volume - I AM UNSURE ABOUT THIS!!!
hold on, colormap gray, axis xy image
update_drawing % easier to call this than to 

%%%%%%%%%% CALLBACK FUNCTIONS %%%%%%%%%%

    function key_press(~,object)
        % keyboard commands
        key = object.Key;
        switch key
            case 'uparrow'
                z = min(z+1,Z);
            case 'downarrow'
                z = max(z-1,1);
            case 'rightarrow'
                z = min(z+10,Z);
            case 'leftarrow'
                z = max(z-10,1);
            case 'pageup'
                z = min(z+50,Z);
            case 'pagedown'
                z = max(z-50,1);
        end
        update_drawing
    end

%%%%%%%%%% HELPING FUNCTIONS %%%%%%%%%%

    function update_drawing
        cla, imagesc(Vdir(:,:,z)',clim)
        title(['slice ',direction,' ',num2str(z),'/',num2str(Z)])
        xlabel(xlab), ylabel(ylab), hold on,
        slice = [0,0,-1,z]; % only one slice, input to mesh_slicer are planes ax+by+cz+d=0 given as (a,b,c,d)
        contours = cell(K);
        for k=1:K
            meshk.faces = mesh{k}.faces;
            meshk.vertices = vertsdir{k};
            contours{k} = mesh_slicer(meshk,slice);
            if ~isempty(contours{k}{1}{1})
                for l = 1:length(contours{k}{1})
                    plot(contours{k}{1}{l}([1:end,1],1),contours{k}{1}{l}([1:end,1],2),'Color',col(k,:))
                end
            end
        end
        drawnow
    end

end







