function draw_mesh_and_slices(V,mesh)
% Author: vand@dtu.dk

[X,Y,Z,~] = size(V);

% volume bounding box
bbox.vertices = [0 0 0; 0 0 Z; 0 Y 0; X 0 0; 0 Y Z; X 0 Z; X Y 0; X Y Z];
bbox.faces = [1 2 6 4; 1 3 5 2; 1 4 7 3; 2 5 8 6; 3 7 8 5; 4 6 8 7];

% drawing
frame = patch(bbox); hold on

if ~iscell(mesh) % only one mesh
    col = [0 1 1];
    patch('Faces',mesh.faces,'Vertices',mesh.vertices,...
        'FaceColor','none','EdgeColor',col,'EdgeAlpha',0.5);
else  % more than one mesh
    col =  num2cell(jet(length(mesh))',1);
    cellfun(@(m,col) patch('Faces',m.faces,'Vertices',m.vertices,...
        'FaceColor','none','EdgeColor',col,'EdgeAlpha',0.5),...
        mesh, col,'UniformOutput',false);
end

V_meshgrid = permute(V,[2 1 3]); % slice assumes MESHGRID format, not NDGRID
cost_slice = slice(V_meshgrid,round((Y+1)/2),round((X+1)/2),round((Z+1)/2)); colormap gray

% setting properties
set(frame,'FaceColor','none','EdgeColor','r','LineWidth',1)
set(cost_slice,'EdgeColor','none','FaceAlpha',0.5)

axis([-0.1*X 1.1*X -0.1*Y 1.1*Y -0.1*Z 1.1*Z]), axis vis3d equal off, %camlight right
view(3)
camlight headlight