function [volume,mesh_inner,mesh_outer] = citrus_volume_and_meshes
% [volume,mesh_inner,mesh_outer] = citrus_volume_and_meshes
% Makes a noisy test volume containing three regions of different intensity 
% and two ground-truth surfaces dividing the regions
% Author: vand@dtu.dk

dim = [200 200 200]; % dimensions of the resulting volume
[X,Y,Z] = ndgrid(1:dim(1),1:dim(2),1:dim(3));

% rotating around volume center
R = axang2rotm([1 2 0 pi/3]); % rotation matrix
c = (dim+1)/2;
PR = R*[X(:)-c(1) Y(:)-c(2) Z(:)-c(3)]';
X(:) = PR(1,:)+c(1);
Y(:) = PR(2,:)+c(2);
Z(:) = PR(3,:)+c(3);

% making the distance fields
phi = atan2(Y-c(2),X-c(1)); % in [-pi,pi]
theta = acos((Z-c(3))./((X-c(1)).^2+(Y-c(2)).^2+(Z-c(3)).^2).^0.5); % in [0,pi]
r_in = min(dim)/4*... basic radius
    (1+0.2*sin(8*phi-0.1*Z).*... slices
    (1-cos(2*theta))/2); % spiraling
r_out = min(dim)/4*... basic radius
    (1.16+0.06*sin(8*phi-0.1*Z).*... slices
    (1-cos(2*theta))/2); % spiraling
V_in = (X-c(1)).^2+(Y-c(2)).^2+(Z-c(3)).^2 - r_in.^2;
V_out = (X-c(1)).^2+(Y-c(2)).^2+(Z-c(3)).^2 - r_out.^2;

% zero surfaces
mesh_inner = reducepatch(isosurface(permute(V_in,[2 1 3]),0),0.01);
mesh_outer = reducepatch(isosurface(permute(V_out,[2 1 3]),0),0.01);

% filling in the values
N = randn(size(V_in));
mu = [0.6 0.9 0.5];
sigma2 = [0.05 0.2 0.05];

volume = min(max((mu(1)+sigma2(1)*N).*(V_in<=0) + (mu(2)+sigma2(2)*N)...
    .*(V_in>0 & V_out<0) + (mu(3)+sigma2(3)*N).*(V_out>=0),0),1);



