clear, close all
addpath('functions')
savepath = '../citrus/';

% NOTE: functions used below assume a ordering of the first and the second
% coordinate which differs from matlabs convention used in e.g. isosurface
% and slice -- fix as it suits your purposes

%% generate and inspect test data
[volume,mesh_inner,mesh_outer] = citrus_volume_and_meshes;
draw_mesh_and_slices(volume,{mesh_inner,mesh_outer})
inspect_volume_and_contours(volume,{mesh_inner,mesh_outer})

%% saving data to be used by WebGL
origin = (size(volume)+1)/2; % WebGL wil always load volume with origo in volume center (despite the value of origin), 
                             % at least I didn't succeed changing this, so I move meshes relative to volume center
mesh_inner.vertices = mesh_inner.vertices - origin;
mesh_outer.vertices = mesh_outer.vertices - origin;

s = 2; % spacing -- for reducing the amount of voxels to draw
Vs = volume(round((s+1)/2):s:end,round((s+1)/2):s:end,round((s+1)/2):s:end);
Vs = uint8(255*Vs); % for some reason, doubles do not load

nrrd_volume_writer([savepath,'volume.nrrd'],Vs,[s s s],origin,'gzip');

obj_save([savepath,'mesh_inner.obj'],mesh_inner.vertices,mesh_inner.faces)
obj_save([savepath,'mesh_outer.obj'],mesh_outer.vertices,mesh_outer.faces)