window.onload = function () {

	var r = new X.renderer3D();
	r.init();
	r.camera.position = [-100, 200, 300];
	r.camera.up = [0, 1, 0];

	// OBJECTS TO VISUALIZE
	var volume = new X.volume();
	volume.file = 'volume.nrrd'; // does not seem to support vti files
	r.add(volume);

	mesh_inner = new X.mesh();
	mesh_inner.file = 'mesh_inner.obj'; // this also supports vtk meshes
	mesh_inner.color = [1,0,0];
	mesh_inner.opacity = 1;
	r.add(mesh_inner);

	mesh_outer = new X.mesh();
	mesh_outer.file = 'mesh_outer.obj';
	mesh_outer.color = [0,1,0.5];
	mesh_outer.opacity = 0.2;
	r.add(mesh_outer);

	// GUI
	var gui = new dat.GUI();
	var volumefolder = gui.addFolder('Volume');
	r.onShowtime = function () {
	    volumefolder.add(volume, 'indexX', 0, volume.dimensions[0] - 1).name('slice x'); // sliceXController
	    volumefolder.add(volume, 'indexY', 0, volume.dimensions[1] - 1).name('slice y'); // sliceYController
	    volumefolder.add(volume, 'indexZ', 0, volume.dimensions[2] - 1).name('slice z'); // sliceZController
	    volumefolder.add(volume, 'opacity', 0, 1).name('opacity');
	}
	volumefolder.open();

	var folder = [];
	var meshfolder = gui.addFolder('Mesh');
	meshfolder.add(mesh_inner, 'opacity',0, 1).name('inner opacity'); // meshVisibleController
	meshfolder.add(mesh_outer, 'opacity',0, 1).name('outer opacity'); // meshVisibleController
	meshfolder.open();

	r.render();

	r.onRender = function () {
			r.camera.rotate([-0.5, 0.1]);
	};

};
