// Skeleton file for property-based testing
// Part 5 of the mini-project on Polynomials
//             Michael R. Hansen  08-08-2023

// Load and open your solutions to Parts 3 and 4.
// An inspiration for doing so could be:
#load "Part3.fsx";;
#load "Part4.fsx";;

open Part3;;
open Part4;;

// Refer to and open FsCheck - maybe done as follows:
#r "nuget: FsCheck";;

open FsCheck


// The fundamental property of ofList is that is converts 
// an integer list to a legal representation of a polynomial
// The type annotation 'xs:int list' is essential
let ofListProp (xs:int list) = isLegal(ofList xs);;

// It is tested using FsCheck as follows
let testOfList = Check.Quick ofListProp;;

// or as follows: Check.Verbose ofListProp;;

type Poly = int list

(*
The following part contains a generator: smallPolyGen, 
to be used by FsCheck to generate legal representations 
of polynomials, values of type Poly, with a certain 
maximal degree and a certain range for coefficients.

You do neither need to consider nor need to change this part.
*)

let maxDegree = 6;;
let maxCoeff = 10;; 

// Generator for small coefficients
let smallCoeffGen = Gen.choose(-maxCoeff,maxCoeff)

// and one for non-zero small coeffocients
let smallNonZeroCoeffGen = 
           gen {let! i = Gen.choose(1,maxCoeff)  (* 1 *)
                let! b = Arb.generate<bool>      (* 2 *)
                return if b then i else -i}      (* 3 *)
(* This is a recipie for a generator that reads: 
(1) generate a number between 1 and maxCoeff - call it i
(2) generate a truth value call it b
(3) return if i if b is true and -i otherwise
*)

// A generator for polynomials with degree i
let polyGenN i = gen {let! last = smallNonZeroCoeffGen
                      let! prefix = Gen.listOfLength (i-1) smallCoeffGen
                      return List.rev (last::prefix)}

// A generator for small polynomials
let smallPolyGen = gen {let! i = Gen.choose(0,maxDegree+1)
                        return! if i=0 then Gen.constant []
                                else polyGenN i}

// The following "registration" make FsCheck use smallPolyGen for the 
// generation of legal polynomials of degree at most maxDegree

type MyGenerator =
  static member Poly() =
      {new Arbitrary<Poly>() with
          override x.Generator = smallPolyGen
          override x.Shrinker t = seq []};;
Arb.register<MyGenerator>();;


// FsCheck will from now on generate values of type Poly
// that are legal polynomials.



// Part 4.1: Checking invariant

// We show below how the invariant for the function 'add' can be 
// validated. Note that the type annotations 'p1:Poly' and 
// 'p2:Poly' are essential:  
let addInvProp (p1:Poly) (p2:Poly) = isLegal(add p1 p2);;
let testAddInv = Check.Quick addInvProp;;

// You can now solve the remaining parts of Part5 of the mini-project. 

